<?php

class Controller extends CController
{
	public $layout = '//layouts/main';

	public $menu = array();
	public $breadcrumbs = array();

	public $metaDescription = '';
	public $metaKeywords = '';

	protected function beforeRender($view)
	{
		if(!empty($this->metaDescription))
			Yii::app()->clientScript->registerMetaTag($this->metaDescription, 'description');

		if(!empty($this->metaKeywords))
			Yii::app()->clientScript->registerMetaTag($this->metaKeywords, 'keywords');

		return parent::beforeRender($view);
	}

	protected function beforeAction($action)
	{
//		if(Yii::app()->user->isStudent && in_array($this->module->id, array('administration','teacher')))
//			Yii::app()->user->logout();
//
//		else
			if((Yii::app()->user->isTeacher || Yii::app()->user->isAdministrator) && (($this->module !== null && $this->module->id == 'student') || ($this->id == 'site' && $action->id == 'index')))
			Yii::app()->user->logout();

		return parent::beforeAction($action);
	}
}